<?php

namespace App\Jobs;

use App\Mail\RecalculatingTSV;
use App\Models\Member;
use App\Models\User;
use App\Models\Bv;
use App\Models\WalletLog;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class MemberImport implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */

    //  import the customer CSV to DB
    public $uploadedFilePath = "";

    public function __construct($uploadedFilePath)
    {
        $this->uploadedFilePath = $uploadedFilePath;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $filePath = $this->uploadedFilePath;
        if (!file_exists($filePath) || !is_readable($filePath)) {
            return false;
        }

        $header = null;
        $i = 0;
        if (($handle = fopen($filePath, 'r')) !== false) {
            while (($temp = fgetcsv($handle, 0, ',')) !== false) {

                if($temp[0] != 'id'){

                    try {
                        $insert_data = [
                            'id' => $temp[0] ?? null,
                            'user_id' => $temp[1] ?? null,
                            'value' => $temp[2] ?? null,
                            'source' => $temp[3] ?? null,
                            'origin' => $temp[4] ?? null,
                            'data' => $temp[5] ?? null,
                            'created_at' => trim($temp[6] ?? null),
                            'unique_id' => $temp[7] ?? null,
                        ];
                        Bv::create($insert_data);
        
                        /*$insert_data = [
                            'id' => $temp[0] ?? null,
                            'wallet_id' => $temp[1] ?? null,
                            'action' => $temp[2] ?? null,
                            'data' => $temp[3] ?? null,
                            'value' => $temp[4] ?? null,
                            'balance' => $temp[5] ?? null,
                            'created_at' => $temp[6] ?? null,
                            'updated_at' => trim($temp[7] ?? null),
                            'status' => trim($temp[8] ?? null),
                            'unique_id' => trim($temp[9] ?? null),
                        ];
                        WalletLog::create($insert_data);*/

                        /*$insert_data = [
                            'id' => $temp[0] ?? null,
                            'username' => $temp[1] ?? null,
                            'email' => $temp[2] ?? null,
                            'is_email_verified' => $temp[3] ?? null,
                            'is_kyc_verified' => $temp[4] ?? null,
                            'login_password' => $temp[5] ?? null,
                            'transaction_password' => $temp[6] ?? null,
                            'registered_at' => $temp[7] ?? null,
                            'updated_at' => (!empty($temp[8])) ? date('Y-m-d H:i:s',strtotime($temp[8])) : null,
                            'lastlogged_at' => $temp[9] ?? null,
                            'ccw_id' => $temp[10] ?? null,
                            'sponsor_id' => $temp[11] ?? null,
                            'sponsor_ids' => $temp[12] ?? null,
                            'personal_sponsor_id' => $temp[13] ?? null,
                            'personal_sponsor_ids' => $temp[14] ?? null,
                            'firstname' => $temp[15] ?? null,
                            'lastname' => $temp[16] ?? null,
                            'gender' => $temp[17] ?? null,
                            'birthdate' => $temp[18] ?? null,
                            'language_id' => $temp[19] ?? null,
                            'address_line_1' => $temp[20] ?? null,
                            'address_line_2' => $temp[21] ?? null,
                            'city' => $temp[22] ?? null,
                            'state' => $temp[23] ?? null,
                            'zip' => $temp[24] ?? null,
                            'country_id' => $temp[25] ?? null,
                            'company' => $temp[26] ?? null,
                            'phone' => $temp[27] ?? null,
                            'is_ccw_in_sync' => $temp[28] ?? null,
                            'level' => $temp[29] ?? null,
                            'rank' => $temp[30] ?? null,
                            'customer' => $temp[31] ?? null,
                            'abv' => $temp[32] ?? null,
                            'pgv' => $temp[33] ?? null,
                            'qbv' => $temp[34] ?? null,
                            'tsv' => $temp[35] ?? null,
                            'wtsv' => $temp[36] ?? null,
                            'qualification_period_start' => $temp[37] ?? null,
                            'qualification_period_end' => $temp[38] ?? null,
                            'qualification_period_number' => $temp[39] ?? null,
                            'status' => $temp[40] ?? null,
                            'reg_site' => $temp[41] ?? null,
                        ];
                        User::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);*/
                    } catch (Exception $e){
                        Log::info($e);
                    }
                }

                $i++;
            }
            fclose($handle);
        }
    }

}
