<?php

namespace App\Exports;

use App\Models\Bv;
use Generator;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromGenerator;
use PHPHtmlParser\Dom;
class UsersExport implements FromGenerator
{
    use Exportable;
    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }


    public function generator(): Generator
    {
        dd($this->data['file']);
        $dom = new Dom;
        $path = public_path($this->data['file']);
        $dom->loadFromFile($path);
        $trs  = $dom->find('table tbody tr');

        $header = [
            "id", 'user_id', 'value', 'source', 'origin', 'data', 'created_at', 'unique_id'
        ];


        $reqIndex = [0,1,2,3,4,5,6,7,8];

        yield $header;

        foreach ($trs as $tr) {
            $tds  = $tr->find('td');
            $temp = [];
            foreach ($tds as $key => $td) {


                if (in_array($key, $reqIndex)) {

                    $temp[] = strip_tags($td->text);
                }
            }

            $insert_data = [
                'id' => $temp[0] ?? null,
                'user_id' => $temp[1] ?? null,
                'value' => $temp[2] ?? null,
                'source' => $temp[3] ?? null,
                'origin' => $temp[4] ?? null,
                'data' => $temp[5] ?? null,
                'unique_id' => $temp[6] ?? null,
                'created_at' => trim($temp[7] ?? null),
            ];
            Bv::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
        }
    }
}
