<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Bootstrap 5 Template</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

</head>
<body>
<div class="container mt-4">
    <form action="javascript:void(0)" class="m-auto" id="myForm" style="max-width: 400px">
        <div class="mb-3">
            <label for="exampleInputEmail1" class="form-label">Start Date</label>
            <input type="date" class="form-control" id="start_date" name="start_date" max="{{ date('Y-m-d') }}">
        </div>
        <div class="mb-3">
            <label for="exampleInputEmail1" class="form-label">End Date</label>
            <input type="date" class="form-control" id="end_date" name="end_date" max="{{ date('Y-m-d') }}">
        </div>
        
        <!-- START for check box -->
        <div class="form-check">
          <input class="form-check-input" type="checkbox" value="user" name='type[]' id='user_type'>
          <label class="form-check-label" for="user_type">
            User
          </label>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="checkbox" value="purchase" name='type[]' id='purchase_type'>
          <label class="form-check-label" for="purchase_type">
            Purchase
          </label>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="checkbox" value="deposit" name='type[]' id='deposit_type'>
          <label class="form-check-label" for="deposit_type">
            Deposit (Action : 7)
          </label>
        </div>
        <!-- END for check box -->
        
        <p class="response_success_msg msg text-success fw-bold"></p>
        <p class="response_error_msg msg text-danger fw-bold"></p>
        <button type="submit" id="SubmitBtn" class="btn btn-success" >Sync Now</button>
    </form>
    <div id="linkDiv" class="m-auto text-center" style="display: none">
        <h5 class="text-center text-success fw-bold" id="linkDisplay"></h5>
        <button class="btn btn-primary" onclick="window.location.reload()">Back</button>
    </div>
</div>


<!-- jQuery first -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js" ></script>

<!-- Then Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" ></script>


<script>
    $(document).on('submit','#myForm',function () {
        $('.response_error_msg').html('');
        var btnHtml = $("#SubmitBtn").html();
        $("#SubmitBtn").attr('disabled',true).html('loading...');
        var formData = new FormData($("#myForm")[0]); // ✅ fixed
        $.ajax({
            url: "{{ url('automation/generate-link') }}",
            type: "POST",
            data: formData,
            headers: {
                "X-CSRF-TOKEN": "{{ csrf_token() }}",
            },
            processData: false,
            contentType: false,
            success: function(response, textStatus, jqXHR) {
                // handle success
                if(response.status){
                    $("#myForm").remove();
                    $("#linkDiv").show();
                    $("#linkDisplay").html(response.link);
                } else {
                    $("#SubmitBtn").attr('disabled',true).html(btnHtml);
                    $(".response_error_msg").html(response.msg);
                }
            },
            error: function (response) {
                // handle error
                $("#SubmitBtn").attr('disabled',false).html(btnHtml);
                
                let allErrors = '';

                // Loop through the errors object
                $.each(response.responseJSON.errors, function(key, messages) {
                    // messages is an array, so join it (in case there are multiple messages per field)
                     allErrors += messages.join('<br>') + '<br>';
                });

                // Trim and set the text inside the <p> tag
                $('.response_error_msg').html(allErrors.trim());
            }
        });
    });

    $(document).on('change','#start_date,#end_date',function () {
        var startDate =  $("#start_date").val();
        var endDate =  $("#end_date").val();
        if(startDate != '' && endDate != '') {
            get_record_count();
        }
    });

    function get_record_count() {
        $("#SubmitBtn").attr('disabled',true).attr('hidden',true);
        var formData = new FormData($("#myForm")[0]); // ✅ fixed
        $.ajax({
            url: "{{ url('automation/get-record-count') }}",
            type: "POST",
            data: formData,
            headers: {
                "X-CSRF-TOKEN": "{{ csrf_token() }}",
            },
            processData: false,
            contentType: false,
            success: function(response, textStatus, jqXHR) {
                // handle success
                if(response.status){
                    $("#SubmitBtn").attr('disabled',false).removeAttr('hidden');
                    $(".response_success_msg").html(response.msg);
                } else {
                    $("#SubmitBtn").attr('disabled',true).attr('hidden',true);
                    $(".response_error_msg").html(response.msg);
                }
            },
            error: function (data) {
                // handle error
                $("#SubmitBtn").attr('disabled',true).attr('hidden',true);
                console.log(response);
            }
        });
    }

</script>
</body>
</html>
