<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\BrowserAutomationController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


Route::get('upload', [HomeController::class,'index']);
Route::get('testing', [HomeController::class,'testing']);
Route::post('upload',[HomeController::class,'upload']);

/*=========================================================================================================*/

Route::controller(BrowserAutomationController::class)->prefix('automation')->group(function (){
    Route::get('/','index');
    Route::post('/get-record-count','getRecordCount');
    Route::post('/generate-link','generateLink');

    Route::get('/get-record','getRecord');
    Route::get('/all-record','allRecord');
});