<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Jobs\DoneAllJob;
use App\Jobs\FetchDepositTicketJob;
use App\Jobs\FetchWithdrawalRequestJob;
use App\Jobs\HtmlToDatabaseJob;
use App\Models\Bv;
use App\Models\CsrPurchase;
use App\Models\CurrencyRedemptionRate;
use App\Models\HtmlFile;
use App\Models\Purchase;
use App\Models\User;
use App\Models\UserCsrAddress;
use App\Models\UserExtra;
use App\Models\UserQualificationLog;
use App\Models\UserTeamsiteLicense;
use App\Models\Wallet;
use App\Models\WalletLog;
use App\Models\UserNote;
use App\Models\PurchaseCoupon;
use App\Models\PurchasePackage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class ApiController extends Controller
{
    protected function pendingFileCount($type){
        return HtmlFile::where('is_complete','No')->where('type',$type)->count();
    }

    public function uploadFile(Request $request)
    {
        $request->validate([
            'file' => 'required',
            'type' => 'required|in:BV,wallet_log,user_teamsite_license,user_qualification_log,user,currency_redemption_rate,wallet,user_extra,user_csr_address,csr_purchase,purchase,user_note,purchase_coupon,purchase_package',
        ]);

        $fileName = time().rand().'.html';
        File::put(public_path("uploads/$fileName"),$request->file);
        HtmlFile::create([
            'file' => "uploads/$fileName",
            'type' => $request->type,
        ]);
        return response()->json(['status' => 'Success','message' => 'File save successfully']);
    }
    
    public function importDone(Request $request)
    {

        \Log::info("Its working now perfect");

        /*-------- START for import new deposit withdrawal data --------*/
        FetchDepositTicketJob::dispatch();
        FetchWithdrawalRequestJob::dispatch();
        /*-------- END for import new deposit withdrawal data --------*/

        $typeArray = [
            'user',
            'user_teamsite_license',
            'user_extra',
            'user_qualification_log',
            'bv',
            'wallet',
            'wallet_log',
            'user_note',
            'csr_purchase',
            'purchase_coupon',
            'purchase_package',
            'purchase',
        ];

        foreach ($typeArray as $type) {
            $data['type'] = $type;
            HtmlToDatabaseJob::dispatch($data);
        }
        
        DoneAllJob::dispatch();

        return response()->json(['status' => 'Success','message' => 'import started']);
    }

    public function startProcess(Request $request)
    {
        if ($request->type) {
            $data['type'] = $request->type;
            HtmlToDatabaseJob::dispatch($data);
            return response()->json(['status' => 'Success','message' => 'Job Started']);
        }
        return response()->json(['status' => 'fail','message' => 'type is empty']);
    }

    public function getStatus()
    {
        $data = HtmlFile::latest()->get(['file','type','is_complete','is_complete']);
        return response()->json($data);
    }

    public function bvInformation(Request $request)
    {
        $data = [
            'total_records' => Bv::count(),
            'last_record_id' => Bv::orderBy('id','DESC')->value('id'),
            'pending_file' => $this->pendingFileCount('BV'),
        ];

        return response()->json($data);
    }
    public function csrpurchaseInformation(Request $request)
    {
        $data = [
            'total_records' => CsrPurchase::count(),
            'last_record_id' => CsrPurchase::orderBy('id','DESC')->value('id'),
            'pending_file' => $this->pendingFileCount('csr_purchase'),
        ];

        return response()->json($data);
    }
    public function usercsraddressInformation(Request $request)
    {
        $data = [
            'total_records' => UserCsrAddress::count(),
            'last_record_id' => UserCsrAddress::orderBy('id','DESC')->value('id'),
            'pending_file' => $this->pendingFileCount('user_csr_address'),
        ];

        return response()->json($data);
    }
    public function currencyredemptionrateInformation(Request $request)
    {
        $data = [
            'total_records' => CurrencyRedemptionRate::count(),
            'last_record_id' => CurrencyRedemptionRate::orderBy('id','DESC')->value('id'),
            'pending_file' => $this->pendingFileCount('currency_redemption_rate'),
        ];

        return response()->json($data);
    }
    public function purchaseInformation(Request $request)
    {
        $data = [
            'total_records' => Purchase::count(),
            'last_record_id' => Purchase::orderBy('id','DESC')->value('id'),
            'pending_file' => $this->pendingFileCount('purchase'),
        ];

        return response()->json($data);
    }
    public function userextraInformation(Request $request)
    {
        $data = [
            'total_records' => UserExtra::count(),
            'last_record_id' => UserExtra::orderBy('id','DESC')->value('id'),
            'pending_file' => $this->pendingFileCount('user_extra'),
        ];

        return response()->json($data);
    }
    public function userqualificationlogInformation(Request $request)
    {
        $data = [
            'total_records' => UserQualificationLog::count(),
            'last_record_id' => UserQualificationLog::orderBy('id','DESC')->value('id'),
            'pending_file' => $this->pendingFileCount('user_qualification_log'),
        ];

        return response()->json($data);
    }
    public function userteamsitelicenseInformation(Request $request)
    {
        $data = [
            'total_records' => UserTeamsiteLicense::count(),
            'last_record_id' => UserTeamsiteLicense::orderBy('id','DESC')->value('id'),
            'pending_file' => $this->pendingFileCount('user_teamsite_license'),
        ];

        return response()->json($data);
    }
    public function userInformation(Request $request)
    {
        $data = [
            'total_records' => User::count(),
            'last_record_id' => User::orderBy('updated_at','DESC')->value('updated_at') ?? '1970-05-28',
            'pending_file' => $this->pendingFileCount('user'),
        ];

        return response()->json($data);
    }
    public function walletInformation(Request $request)
    {
        $updated_at = Wallet::orderBy('updated_at','DESC')->value('updated_at');
        $data = [
            'total_records' => Wallet::count(),
            'last_record_id' => date('Y-m-d h:i:s',strtotime($updated_at)),
            'pending_file' => $this->pendingFileCount('wallet'),
        ];

        return response()->json($data);
    }
    public function walletlogInformation(Request $request)
    {
        $data = [
            'total_records' => WalletLog::count(),
            // 'last_record_id' => WalletLog::orderBy('updated_at','DESC')->value('updated_at'),
            // 'last_record_id' =>  '2025-07-05 00:00:01',
            'last_record_id' =>  date('Y-m-d',strtotime('-1 day')),
            'pending_file' => $this->pendingFileCount('wallet_log'),
        ];

        return response()->json($data);
    }
    public function usernotesInformation(Request $request)
    {
        $data = [
            'total_records' => UserNote::count(),
            // 'last_record_id' => UserNote::orderBy('updated_at','DESC')->value('updated_at'),
            'last_record_id' =>  date('Y-m-d',strtotime('-1 day')),
            'pending_file' => $this->pendingFileCount('user_note'),
        ];

        return response()->json($data);
    }
    
    public function purchaseCouponInformation(Request $request)
    {
        $data = [
            'total_records' => PurchaseCoupon::count(),
            // 'last_record_id' => UserNote::orderBy('updated_at','DESC')->value('updated_at'),
            'last_record_id' => PurchaseCoupon::orderBy('updated_at','DESC')->value('updated_at') ?? '1970-05-28',
            // 'last_record_id' =>  date('Y-m-d',strtotime('-1 day')),
            'pending_file' => $this->pendingFileCount('purchase_coupon'),
        ];

        return response()->json($data);
    }
    
     public function purchasePackageInformation(Request $request)
    {
        $data = [
            'total_records' => 0,
            'last_record_id' =>  PurchasePackage::orderBy('updated_at','DESC')->value('id') ?? 1,
            // 'last_record_id' =>  date('Y-m-d',strtotime('-1 day')),
            'pending_file' => $this->pendingFileCount('purchase_package'),
        ];

        return response()->json($data);
    }
}
