<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Jobs\HtmlToDatabaseJob;
use App\Models\Bv;
use App\Models\CsrPurchase;
use App\Models\CurrencyRedemptionRate;
use App\Models\HtmlFile;
use App\Models\Purchase;
use App\Models\PurchasePackage;
use App\Models\User;
use App\Models\UserCsrAddress;
use App\Models\UserExtra;
use App\Models\UserQualificationLog;
use App\Models\UserTeamsiteLicense;
use App\Models\Wallet;
use App\Models\WalletLog;
use App\Models\UserNote;
use App\Models\PurchaseCoupon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class BrowserAutomationApiController extends Controller
{
    public function getGiftCodeData($giftCode)
    {
        $msg = 'No record found';

        $giftCodeData = PurchaseCoupon::where('coupon','like',"$giftCode%")->first();

        if ($giftCodeData) {
            $product = Purchase::where('id', $giftCodeData->purchase_id)->first();
            if ($product) {
                $purchasePackage = PurchasePackage::where('id', $giftCodeData->purchase_package_id)->first();
                if ($purchasePackage) {
                    $type = 'package';
                    if (strtoupper(substr($giftCode, 0, 2)) === 'BL') {
                        $type = 'licence';
                    }
                    $username = User::where('id',$product->user_id)->value('username');
                    $data = [
                        'user_id' => $product->user_id,
                        'username' => $username ?? '',
                        'price' => intval($purchasePackage->price),
                        'type' => $type,
                    ];
                    return response()->json(['status' => 'success','data' => $data]);
                } else {
                    $msg = 'No product package found';
                }
            } else {
                $msg = 'No product found';
            }
        } else {
            $msg = 'No giftcode found';
        }

        return response()->json(['status' => 'fail','msg' => $msg]);
    }
}
