<?php

namespace App\Http\Controllers;

use App\Jobs\MemberImport;
use App\Models\HtmlFile;
use App\Models\BrowserAutomation;
use App\Models\BrowserAutomationData;
use App\Models\Purchase;
use App\Models\PurchaseCoupon;
use App\Models\PurchasePackage;
use App\Models\Setting;
use App\Models\User;
use App\Models\Bv;
use App\Models\Wallet;
use App\Models\WalletLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PHPHtmlParser\Dom;
use App\Jobs\DoneAllJob;

class BrowserAutomationController extends Controller
{
    public function index()
    {
        // $purchase_id = 276446;
        // $purchaseAll = Purchase::where('id',$purchase_id)->get();

        // if (!empty($purchaseAll)) {
        //     foreach ($purchaseAll as $purchase){
        //         $user = User::where('id',$purchase->user_id)->first();
        //         $userEmail = $user->username ?? '';
        //         // $userEmail = 'kp@mailinator.com';

        //         if ($purchase->type == 'coupon') {
        //             $purchasePackage = PurchasePackage::where('purchase_id', $purchase_id)->get();

        //             $item = [];
        //             foreach ($purchasePackage as $package) {
        //                 $purchaseCoupon = PurchaseCoupon::where('purchase_package_id', $package->id)->first();
        //                 $type = 'package';
        //                 $pName = 'PNP';
        //                 if (strtoupper(substr(($purchaseCoupon->coupon ?? ''), 0, 2)) === 'BL') {
        //                     $type = 'licence';
        //                     $pName = 'LIC';
        //                 }

        //                 if($purchase->wallet_type == 1){
        //                     $walletName = 'OCA';
        //                 } else {
        //                     $walletName = 'Bonus wallet';
        //                 }

        //                 $item[] = [
        //                     "package" => $pName."-" . number_format($package->price, 0),
        //                     "type" => $type,
        //                     "qty" => $package->piece,
        //                     "wallet" => $walletName,
        //                 ];
        //             }

        //             $jayParsedAry = [
        //                 "email" => $userEmail,
        //                 "password" => "password@1",
        //                 "metadata" => [
        //                     "items" => $item,
        //                 ]
        //             ];
                    
        //             dd($jayParsedAry);

        //             // BrowserAutomationData::create([
        //             //     'user_id' => $purchase->user_id,
        //             //     'type' => 'purchase',
        //             //     'data' => $jayParsedAry,
        //             //     'action' => '',
        //             //     'datetime' => $purchase->created_at,
        //             // ]);
        //         }
        //     }
        // }
                
        // DoneAllJob::dispatch();
        return view('browser-automation');
    }

    public function getRecordCount(Request $request)
    {
        if ($request->start_date && $request->end_date){
            $startDate = date('Y-m-d',strtotime($request->start_date));
            $endDate = date('Y-m-d',strtotime($request->end_date));
            $userCount = User::whereDate('registered_at', '>=', $startDate)
                ->whereDate('registered_at', '<=', $endDate)
                ->count();

            return response()->json(['status' => true,'msg' => "Total $userCount users found."]);
        } else {
            return response()->json(['status' => false,'msg' => 'Start and end date both are required.'],422);
        }
    }

    public function generateLink(Request $request)
    {
        $request->validate([
            'start_date' => 'required',
            'end_date' => 'required',
            'type' => 'required|array',
            'type.*' => 'required|string', // Or any rule that matches the type of value
        ],[
            'type[].required' => 'The type field is required.'
        ]);

        if ($request->start_date && $request->end_date){
            $startDate = date('Y-m-d',strtotime($request->start_date));
            $endDate = date('Y-m-d',strtotime($request->end_date));
            $type = implode(',',$request->type ?? []);

            // $url = url('automation/get-record')."?start_date=$startDate&end_date=$endDate";
            BrowserAutomation::create(['start_date' => $startDate,'end_date' => $endDate,'type' => $type]);
            return response()->json(['status' => true,'link' => 'Submitted successfully.']);
        } else {
            return response()->json(['status' => false,'msg' => 'Start and end date both are required.'],422);
        }
    }

    public function getRecord(Request $request)
    {
        $data = BrowserAutomation::latest()->first();
        if (!empty($data)){
            $startDate = date('Y-m-d',strtotime($data->start_date));
            $endDate = date('Y-m-d',strtotime($data->end_date));

            $user = User::with('sponsor:id,username')
                ->select('*', DB::raw("
                    CASE
                        WHEN (firstname IS NULL OR firstname = '')
                          AND (lastname IS NULL OR lastname = '')
                        THEN 'NA First'
                        ELSE firstname
                    END AS firstname,
                    CASE
                        WHEN (firstname IS NULL OR firstname = '')
                          AND (lastname IS NULL OR lastname = '')
                        THEN 'NA Last'
                        ELSE lastname
                    END AS lastname
                "))
                ->whereDate('registered_at', '>=', $startDate)
                ->whereDate('registered_at', '<=', $endDate)
                ->orderBy('registered_at','ASC')->offset(3)->limit(5)->get();

            return response()->json($user);
        } else {
            return response()->json(['status' => false,'msg' => 'Start and end date both are required.'],422);
        }
    }

    public function allRecord(Request $request)
    {
        $data = BrowserAutomation::latest()->first();
        if (!empty($data)){
            $type = explode(',',$data->type ?? '');
            $startDate = date('Y-m-d',strtotime($data->start_date));
            $endDate = date('Y-m-d',strtotime($data->end_date));

            $record = BrowserAutomationData::with('user:id,username,email')
                // ->where(function ($q) use ($type) {
                //     if(in_array('user',$type)){
                //         $q->orWhere('type','user');
                //     }
                //     if(in_array('purchase',$type)){
                //         $q->orWhere('type','purchase');
                //     }
                //     if(in_array('deposit',$type)){
                //         $q->orWhere(function ($q1){
                //             $q1->where(['type' => 'wallet_log','action' => 7]);
                //         });
                //     }
                // })
                // ->whereDate('datetime', '>=', $startDate)
                // ->whereDate('datetime', '<=', $endDate)
                // ->whereIn('id', [88])
                // ->where('type', 'wallet_withdrawal')
                // ->where('id','!=','5')
                // ->where('id','487')
                ->where('is_done','0')
                ->orderBy('datetime','ASC')
                // ->limit(2)
                ->get();


            return response()->json(['data' => $record,'count' => count($record)]);
        } else {
            return response()->json(['status' => false,'msg' => 'Start and end date both are required.'],422);
        }
    }

    public function setPurchaseData($purchase_id,Request $request)
    {
        // $purchaseAll = Purchase::where('id','>',$lastPurchaseId)->orderBy('id','ASC')->get();
        $purchaseAll = Purchase::where('id',$purchase_id)->get();

        if (!empty($purchaseAll)) {
            foreach ($purchaseAll as $purchase){
                $user = User::where('id',$purchase->user_id)->first();
                $userEmail = $user->email ?? '';
                // $userEmail = 'kp@mailinator.com';

                if ($purchase->type == 'coupon') {
                    $purchasePackage = PurchasePackage::where('purchase_id', $purchase_id)->get();

                    $item = [];
                    foreach ($purchasePackage as $package) {
                        $type = 'package';
                        if ($package->package_id == '38') {
                            $type = 'licence';
                        }

                        $item[] = [
                            "package" => "PNP-" . number_format($package->price, 0),
                            "type" => $type,
                            "qty" => $package->piece
                        ];
                    }

                    $jayParsedAry = [
                        "email" => $userEmail,
                        "password" => "password@1",
                        "metadata" => [
                            "items" => $item,
                        ]
                    ];

                    BrowserAutomationData::create([
                        'user_id' => $purchase->user_id,
                        'type' => 'purchase',
                        'data' => $jayParsedAry,
                        'action' => '',
                        'datetime' => $purchase->created_at,
                    ]);
                }

                if ($purchase->type == 'redeem') {
                    // ---- START for giftcode redeem
                    $giftcode = PurchaseCoupon::where('redeem_purchase_id', $purchase->id)->first();

                    $jayParsedAry = [
                        "email" => $userEmail,
                        "password" => "password@1",
                        "redeem" => [
                            "code" => $giftcode->coupon ?? '',
                        ]
                    ];

                    BrowserAutomationData::create([
                        'user_id' => $giftcode->redeem_user_id,
                        'type' => 'redeem',
                        'data' => $jayParsedAry,
                        'action' => '',
                        'datetime' => $purchase->created_at,
                    ]);
                }
            }

            return response()->json('Success ' . ($purchase->type ?? ''));
        } else {
            return response()->json('No record found');
        }
    }

    public function setDepositData(Request $request)
    {

        $lastDepositId = Setting::where('name','last_deposit_id')->value('value') ?? 0;
        $data = DB::table('wpzj_deposit_ticket')->where('id','>',$lastDepositId)->where('id',8621)->get();
        $count = 0;
        foreach ($data as $deposit){
            $user = User::where('email',$deposit->email)->first();
            if ($user) {
                $jayParsedAry = [
                    "email" => $deposit->email,
                    "password" => "password@1",
                    "deposit" => $deposit
                ];

                BrowserAutomationData::create([
                    'user_id' => $user->id,
                    'type' => 'wallet_deposit',
                    'data' => $jayParsedAry,
                    'action' => '',
                    'datetime' => $deposit->create_date,
                ]);

                $count++;
            } else {
                \Log::info('----- User not found (deposit) ------');
                \Log::info(json_encode($deposit ?? []));
            }
        }

        return response()->json(($count)." deposit data stored");
    }
    
    public function updateStatus($id){
        $data = BrowserAutomationData::find($id);
        $data->is_done = 1;
        $data->save();
        
        return response()->json("Done");
    }
}
