<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class FetchDepositTicketJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle()
    {
        $apiUrl = 'https://academy.amplivo.com/wp-json/custom/v1/deposits-after';

        $latestDepositId = DB::table('wpzj_deposit_ticket')->max('id') ?? 0;

        $response = Http::withoutVerifying()->post($apiUrl, [
            'deposit_id' => $latestDepositId,
        ]);

        if ($response->successful()) {
            $responseData = $response->json();

            if (!empty($responseData['data'])) {
                foreach ($responseData['data'] as $deposit) {
                    DB::table('wpzj_deposit_ticket')->insert([
                        'id' => $deposit['id'] ?? null,
                        'email' => $deposit['email'] ?? null,
                        'username' => $deposit['username'] ?? null,
                        'first_name' => $deposit['first_name'] ?? null,
                        'last_name' => $deposit['last_name'] ?? null,
                        'member_type' => $deposit['member_type'] ?? null,
                        'deposit_type' => $deposit['deposit_type'] ?? null,
                        'blockchain_for_usdt' => $deposit['blockchain_for_usdt'] ?? null,
                        'usdt_amount' => $deposit['usdt_amount'] ?? null,
                        'eth_address' => $deposit['eth_address'] ?? null,
                        'transaction_hash' => $deposit['transaction_hash'] ?? null,
                        'limoswap_value_usd' => $deposit['limoswap_value_usd'] ?? null,
                        'limocoin_transaction_hash' => $deposit['limocoin_transaction_hash'] ?? null,
                        'oca_deposite' => $deposit['oca_deposite'] ?? null,
                        'price_of_limocoin' => $deposit['price_of_limocoin'] ?? null,
                        'status' => $deposit['status'] ?? null,
                        'proof_payment' => $deposit['proof_payment'] ?? null,
                        'fiat_bank_name' => $deposit['fiat_bank_name'] ?? null,
                        'fiat_amount' => $deposit['fiat_amount'] ?? null,
                        'fiat_currency' => $deposit['fiat_currency'] ?? null,
                        'ticket_id' => $deposit['ticket_id'] ?? null,
                        'euro_amount' => $deposit['euro_amount'] ?? null,
                        'create_date' => $deposit['create_date'] ?? now(),
                    ]);
                }
            } else {
                \Log::info('FetchDepositTicketJob: No new deposit data found.');
            }

        } else {
            \Log::error('FetchDepositTicketJob: API request failed with status ' . $response->status());
        }
    }
}
