<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class FetchWithdrawalRequestJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle()
    {
        $apiUrl = 'https://academy.amplivo.com/wp-json/custom/v1/withdrawals-after';

        // Get latest withdrawal id
        $latestWithdrawalId = DB::table('wpzj_withdrawal_requests')->max('id') ?? 0;

        $response = Http::withoutVerifying()->post($apiUrl, [
            'withdrawal_id' => $latestWithdrawalId,
        ]);

        if ($response->successful()) {
            $responseData = $response->json();

            if (!empty($responseData['data'])) {
                foreach ($responseData['data'] as $withdrawal) {
                    DB::table('wpzj_withdrawal_requests')->insert([
                        'id' => $withdrawal['id'] ?? null,
                        'email' => $withdrawal['email'] ?? null,
                        'username' => $withdrawal['username'] ?? null,
                        'name' => $withdrawal['name'] ?? null,
                        'type_of_withdrawal' => $withdrawal['type_of_withdrawal'] ?? null,
                        'account_holder' => $withdrawal['account_holder'] ?? null,
                        'bank_iban' => $withdrawal['bank_iban'] ?? null,
                        'bank_bic' => $withdrawal['bank_bic'] ?? null,
                        'bank_name' => $withdrawal['bank_name'] ?? null,
                        'bank_branch_name' => $withdrawal['bank_branch_name'] ?? null,
                        'bank_address' => $withdrawal['bank_address'] ?? null,
                        'usdt_block_chain' => $withdrawal['usdt_block_chain'] ?? null,
                        'usdt_blockchain_address' => $withdrawal['usdt_blockchain_address'] ?? null,
                        'euro_amount_usdt' => $withdrawal['euro_amount_usdt'] ?? null,
                        'exchange_rate' => $withdrawal['exchange_rate'] ?? null,
                        'usdt_amount_usdt' => $withdrawal['usdt_amount_usdt'] ?? null,
                        'oca_balance' => $withdrawal['oca_balance'] ?? null,
                        'euro_amount_cad' => $withdrawal['euro_amount_cad'] ?? null,
                        'cad_amount_cad' => $withdrawal['cad_amount_cad'] ?? null,
                        'current_step' => $withdrawal['current_step'] ?? null,
                        'status' => $withdrawal['status'] ?? null,
                        'reason' => $withdrawal['reason'] ?? null,
                        'reference' => $withdrawal['reference'] ?? null,
                        'create_date' => $withdrawal['create_date'] ?? now(),
                        'update_date' => $withdrawal['update_date'] ?? now(),
                    ]);
                }
            } else {
                \Log::info('FetchWithdrawalRequestJob: No new withdrawal found.');
            }

        } else {
            \Log::error('FetchWithdrawalRequestJob: API request failed with status ' . $response->status());
        }
    }
}
