<?php

namespace App\Jobs;

use App\Models\Bv;
use App\Models\PurchaseCoupon;
use App\Models\CsrPurchase;
use App\Models\CurrencyRedemptionRate;
use App\Models\HtmlFile;
use App\Models\Purchase;
use App\Models\PurchasePackage;
use App\Models\User;
use App\Models\UserCsrAddress;
use App\Models\UserExtra;
use App\Models\UserQualificationLog;
use App\Models\UserTeamsiteLicense;
use App\Models\Wallet;
use App\Models\WalletLog;
use App\Models\UserNote;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use PHPHtmlParser\Dom;
use App\Models\BrowserAutomationData;

class HtmlToDatabaseJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $data;
    protected $createAutomationData = true;

    /**
     * Create a new job instance.
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        ini_set('max_execution_time', -1);
        $where_array = [
            'is_complete' => 'No',
            'type' => $this->data['type'],
        ];

        $data = HtmlFile::where($where_array)->orderBy('id','ASC')->get();

        foreach ($data as $row){
            $complete = 'Yes';
            /*-------- START for converting data --------*/
            $dom = new Dom;
            $path = public_path($row['file']);
            $dom->loadFromFile($path);
            $trs  = $dom->find('table tbody tr');

            $lastWalletLogId = WalletLog::orderBy('id','desc')->value('id');
            // $lastWalletLogId = 26254657;

            foreach ($trs as $tr) {
                $tds  = $tr->find('td');
                $temp = [];
                foreach ($tds as $key => $td) {
                    $temp[] = strip_tags($td->text);
                }

                if ($row->type == 'BV'){
                    $this->insert_bv($temp);
                } else if ($row->type == 'wallet_log'){
                    $this->insert_wallet_log($temp,$lastWalletLogId);
                } else if ($row->type == 'user_teamsite_license'){
                    $this->insert_user_teamsite_license($temp);
                } else if ($row->type == 'user_qualification_log'){
                    $this->insert_user_qualification_log($temp);
                } else if ($row->type == 'user'){
                    $this->insert_user($temp);
                } else if ($row->type == 'currency_redemption_rate'){
                    $this->insert_currency_redemption_rate($temp);
                } else if ($row->type == 'wallet'){
                    $this->insert_wallet($temp);
                } else if ($row->type == 'user_extra'){
                    $this->insert_user_extra($temp);
                } else if ($row->type == 'user_csr_address'){
                    $this->insert_user_csr_address($temp);
                } else if ($row->type == 'csr_purchase'){
                    $this->insert_csr_purchase($temp);
                } else if ($row->type == 'purchase'){
                    $this->insert_purchase($temp);
                } else if ($row->type == 'user_note'){
                    $this->insert_user_note($temp);
                } else if ($row->type == 'purchase_coupon'){
                    $this->insert_purchase_coupon($temp);
                } else if ($row->type == 'purchase_package'){
                    $this->insert_purchase_package($temp);
                } else {
                    $comment = 'Invalid Type';
                    $complete = 'Canceled';
                }
            }

            $row->is_complete = $complete;
            $row->comment = $comment ?? null;
            $row->save();
        }
    }

    private function insert_purchase_coupon($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'purchase_id' => $temp[1] ?? null,
            'purchase_package_id' => $temp[2] ?? null,
            'notify_user_id' => $temp[3] ?? null,
            'notify_admin_id' => $temp[4] ?? null,
            'redeem_user_id' => $temp[5] ?? null,
            'redeem_purchase_id' => trim($temp[6] ?? null),
            'status' => $temp[7] ?? null,
            'coupon' => $temp[8] ?? null,
            'created_at' => $temp[9] ?? null,
            'updated_at' => $temp[10] ?? null,
            'expired_at' => $temp[11] ?? null,
            'notified_at' => $temp[12] ?? null,
        ];
        PurchaseCoupon::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
        // PurchaseCoupon::create($insert_data);
    }

    private function insert_purchase_package($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'purchase_id' => $temp[1] ?? null,
            'package_id' => $temp[2] ?? null,
            'piece' => $temp[3] ?? null,
            'price' => $temp[4] ?? null,
            'ortp' => $temp[5] ?? null,
            'csr' => $temp[6] ?? null,
            'bv' => $temp[7] ?? null,
            'created_at' => $temp[8] ?? null,
            'updated_at' => $temp[9] ?? null
        ];
        PurchasePackage::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
    }

    private function insert_bv($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'user_id' => $temp[1] ?? null,
            'value' => $temp[2] ?? null,
            'source' => $temp[3] ?? null,
            'origin' => $temp[4] ?? null,
            'data' => $temp[5] ?? null,
            'created_at' => trim($temp[6] ?? null),
            'unique_id' => $temp[7] ?? null,
        ];
        Bv::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
        // Bv::create($insert_data);
    }

    private function insert_wallet_log($temp,$lastWalletLogId=null){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'wallet_id' => $temp[1] ?? null,
            'action' => $temp[2] ?? null,
            'data' => $temp[3] ?? null,
            'value' => $temp[4] ?? null,
            'balance' => $temp[5] ?? null,
            'created_at' => $temp[6] ?? null,
            'updated_at' => trim($temp[7] ?? null),
            'status' => trim($temp[8] ?? null),
            'unique_id' => trim($temp[9] ?? null),
        ];
        // WalletLog::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
        WalletLog::create($insert_data);

        // $user_id = Wallet::where('id',$insert_data['wallet_id'])->value('user_id');
        // BrowserAutomationData::create([
        //     'user_id' => $user_id,
        //     'type' => 'wallet_log',
        //     'data' => json_encode($insert_data),
        //     'action' => $insert_data['action'],
        //     'datetime' => $insert_data['created_at'],
        // ]);


        if ($this->createAutomationData && (is_null($lastWalletLogId) || $insert_data['id'] > $lastWalletLogId)) {
            $data = json_decode($insert_data['data'] ?? []);
            $description = $data->description ?? null;

            if($insert_data['action'] == 7){ // --- START for deposit
                if (stripos($data->description, 'deposit') !== false){
                    preg_match('/(\d+)$/', $description, $matches);
                    $ticketId = $matches[0] ?? null;
                    if (!empty($ticketId)) {
                        $this->setDepositDataForAutomation($ticketId,$insert_data['created_at']);
                    }
                // } else if (stripos($data->description, 'CSR-PO-') !== false){
                } else {
                    $value = abs($insert_data['value'] ?? 0);
                    $userId = Wallet::where('id', $insert_data['wallet_id'])->value('user_id');
                    $this->setCsrNowPurchaseAdDeposit($userId,$value,$insert_data['updated_at'],$description);
                }
            } else if ($insert_data['action'] == 46 && $description == 'Request Withdrawal'){ // --- START for Withdrawal
                $value = abs($insert_data['value'] ?? 0);
                if (!empty($value)){
                    $userId = Wallet::where('id', $insert_data['wallet_id'])->value('user_id');
                    if (!empty($userId)){
                        $this->setWithdrawalDataForAutomation($userId,$value,$insert_data['created_at']);
                    }
                }
            } else if ($insert_data['action'] == 5){ // --- START for internal transfer
                $value = abs($insert_data['value'] ?? 0);
                $transferTo = $data->username ?? '';
                if (!empty($value) && !empty($transferTo)) {
                    $userId = Wallet::where('id', $insert_data['wallet_id'])->value('user_id');
                    if (!empty($userId)) {
                        $this->setInternalTransferData($userId, $value,$transferTo,$insert_data['created_at']);
                    }
                }
            }
        }
    }

    private function setInternalTransferData($userId,$value,$transferTo,$created_at=null){
        $user = User::find($userId);
        if ($user) {
            $transfer = [
                'transfer_to' => $transferTo,
                'amount' => number_format($value, 2, '.', ''),
            ];

            $jayParsedAry = [
                "email" => $user->username,
                "password" => "password@1",
                "transfer" => $transfer
            ];

            if (empty($created_at)) {
                $created_at = now();
            }

            BrowserAutomationData::create([
                'user_id' => $userId,
                'type' => 'internal_transfer',
                'data' => $jayParsedAry,
                'action' => $transferTo,
                'datetime' => $created_at,
            ]);
        }
    }

    private function setCsrNowPurchaseAdDeposit($userId,$value,$created_at=null,$description=null){
        $user = User::find($userId);
        if ($user) {
            $deposit = [
                'id' => 8934,
                'email' => $user->email,
                'username' => 'xyz',
                'first_name' => 'xyz',
                'last_name' => 'xyz',
                'member_type' => 'Amplivo Member',
                'deposit_type' => 'EUR',
                'blockchain_for_usdt' => null,
                'usdt_amount' => 1,
                'eth_address' => null,
                'transaction_hash' => '1',
                'limoswap_value_usd' => null,
                'limocoin_transaction_hash' => null,
                'oca_deposite' => '1',
                'price_of_limocoin' => '0.005',
                'status' => 1,
                'proof_payment' => 'proof_payment_7022_9938469_1750622284.pdf',
                'fiat_bank_name' => 'Mountain Wolf',
                'fiat_amount' => $value,
                'fiat_currency' => 'EURO',
                'ticket_id' => 0,
                'euro_amount' => 1,
                'create_date' => '1909-01-01 19:58:04'
            ];

            $jayParsedAry = [
                "email" => $user->username,
                "password" => "password@1",
                "deposit" => $deposit
            ];

            if (empty($created_at)) {
                $created_at = now();
            }

            BrowserAutomationData::create([
                'user_id' => $userId,
                'type' => 'wallet_deposit',
                'data' => $jayParsedAry,
                'action' => $description,
                'datetime' => $created_at,
            ]);
        }
    }
    private function setWithdrawalDataForAutomation($userId,$value,$created_at=null){
        $user = User::where('id', $userId)->first();
        if (!empty($user)){
            $email = $user->email;
            $withdrawal = DB::table('wpzj_withdrawal_requests')
                ->where([
                    'email'=>$email,
                    'euro_amount_usdt'=>$value
                ])->first();
            if ($withdrawal) {
                $jayParsedAry = [
                    "email" => $user->username,
                    "password" => "password@1",
                    "withdrawal" => $withdrawal
                ];

                if (empty($created_at)){
                    $created_at = $withdrawal->create_date ?? null;
                }

                BrowserAutomationData::create([
                    'user_id' => $user->id,
                    'type' => 'wallet_withdrawal',
                    'data' => $jayParsedAry,
                    'action' => '',
                    'datetime' => $created_at,
                ]);
            }
        } else {
            \Log::info('----- User not found (Withdrawal) ------');
            \Log::info(json_encode(['userId' => $userId,'value' => $value,'created_at' => $created_at]));
        }
    }

    private function setDepositDataForAutomation($ticketId,$created_at=null){
        $deposit = DB::table('wpzj_deposit_ticket')->where('ticket_id',$ticketId)->first();
        if ($deposit) {
            $user = User::where('email', $deposit->email)->first();
            if ($user) {
                // Convert EURO to EUR
                $depositType = strtoupper($deposit->deposit_type ?? '');
                if ($depositType === 'EURO') {
                    $deposit->deposit_type = 'EUR';
                }

                $jayParsedAry = [
                    "email" => $user->username,
                    "password" => "password@1",
                    "deposit" => $deposit
                ];

                if (empty($created_at)){
                    $created_at = $deposit->create_date ?? null;
                }

                BrowserAutomationData::create([
                    'user_id' => $user->id,
                    'type' => 'wallet_deposit',
                    'data' => $jayParsedAry,
                    'action' => $ticketId,
                    'datetime' => $created_at,
                ]);
            } else {
                \Log::info('----- User not found (deposit) ------');
                \Log::info(json_encode($deposit ?? []));
            }
        }
    }

    private function insert_user_teamsite_license($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'user_id' => $temp[1] ?? null,
            'type' => $temp[2] ?? null,
            'start' => $temp[4] ?? null,
            'end' => $temp[5] ?? null,
            'created_at' => $temp[6] ?? null,
        ];
        UserTeamsiteLicense::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
    }

    private function insert_user_qualification_log($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'user_id' => $temp[1] ?? null,
            'type' => $temp[2] ?? null,
            'source' => $temp[3] ?? null,
            'value' => $temp[4] ?? null,
            'value_before' => $temp[5] ?? null,
            'data' => $temp[6] ?? null,
            'created_at' => $temp[7] ?? null,
        ];
        UserQualificationLog::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
    }

    private function insert_user($temp){

        // $insert_data = [
        //     'id' => $temp[0] ?? null,
        //     'username' => $temp[1] ?? null,
        //     'email' => $temp[2] ?? null,
        //     'is_email_verified' => $temp[3] ?? null,
        //     'is_kyc_verified' => $temp[4] ?? null,
        //     'login_password' => $temp[5] ?? null,
        //     'transaction_password' => $temp[6] ?? null,
        //     'registered_at' => $temp[7] ?? null,
        //     'updated_at' => $temp[8] ?? null,
        //     'lastlogged_at' => $temp[9] ?? null,
        //     'ccw_id' => $temp[10] ?? null,
        //     'sponsor_id' => $temp[11] ?? null,
        //     'personal_sponsor_id' => $temp[12] ?? null,
        //     'firstname' => $temp[13] ?? null,
        //     'lastname' => $temp[14] ?? null,
        //     'gender' => $temp[15] ?? null,
        //     'birthdate' => $temp[16] ?? null,
        //     'language_id' => $temp[17] ?? null,
        //     'address_line_1' => $temp[18] ?? null,
        //     'address_line_2' => $temp[19] ?? null,
        //     'city' => $temp[20] ?? null,
        //     'state' => $temp[21] ?? null,
        //     'zip' => $temp[22] ?? null,
        //     'country_id' => $temp[23] ?? null,
        //     'company' => $temp[24] ?? null,
        //     'phone' => $temp[25] ?? null,
        //     'is_ccw_in_sync' => $temp[26] ?? null,
        //     'level' => $temp[27] ?? null,
        //     'rank' => $temp[28] ?? null,
        //     'customer' => $temp[29] ?? null,
        //     'abv' => $temp[30] ?? null,
        //     'pgv' => $temp[31] ?? null,
        //     'qbv' => $temp[32] ?? null,
        //     'tsv' => $temp[33] ?? null,
        //     'wtsv' => $temp[34] ?? null,
        //     'qualification_period_start' => $temp[35] ?? null,
        //     'qualification_period_end' => $temp[36] ?? null,
        //     'qualification_period_number' => $temp[37] ?? null,
        //     'status' => $temp[38] ?? null,
        //     'reg_site' => $temp[39] ?? null,
        // ];

        $insert_data = [
            'id' => $temp[0] ?? null,
            'username' => $temp[1] ?? null,
            'email' => $temp[2] ?? null,
            'is_email_verified' => $temp[3] ?? null,
            'is_kyc_verified' => $temp[4] ?? null,
            'login_password' => $temp[5] ?? null,
            'transaction_password' => $temp[6] ?? null,
            'registered_at' => $temp[7] ?? null,
            'updated_at' =>  $temp[8] ? date('Y-m-d H:i:s', strtotime($temp[8])) : null,
            'lastlogged_at' => $temp[9] ?? null,
            'ccw_id' => $temp[10] ?? null,
            'sponsor_id' => $temp[11] ?? null,
            // 'sponsor_ids' => $temp[12] ?? null,
            'personal_sponsor_id' => $temp[12] ?? null,
            // 'personal_sponsor_ids' => $temp[14] ?? null,
            'firstname' => preg_replace('/[^A-Za-z ]/', '', $temp[13] ?? null),
            'lastname' => preg_replace('/[^A-Za-z ]/', '', $temp[14] ?? null),
            'gender' => $temp[15] ?? null,
            'birthdate' => $temp[16] ?? null,
            'language_id' => $temp[17] ?? null,
            'address_line_1' => $temp[18] ?? null,
            'address_line_2' => $temp[19] ?? null,
            'city' => $temp[20] ?? null,
            'state' => $temp[21] ?? null,
            'zip' => $temp[22] ?? null,
            'country_id' => $temp[23] ?? null,
            'company' => $temp[24] ?? null,
            'phone' => $temp[25] ?? null,
            'is_ccw_in_sync' => $temp[26] ?? null,
            'level' => $temp[27] ?? null,
            'rank' => $temp[28] ?? null,
            'customer' => $temp[29] ?? null,
            'abv' => $temp[30] ?? null,
            'pgv' => $temp[31] ?? null,
            'qbv' => $temp[32] ?? null,
            'tsv' => $temp[33] ?? null,
            'wtsv' => $temp[34] ?? null,
            'qualification_period_start' => $temp[35] ?? null,
            'qualification_period_end' => $temp[36] ?? null,
            'qualification_period_number' => $temp[37] ?? null,
            'status' => $temp[38] ?? null,
            'reg_site' => $temp[39] ?? null,
        ];

        $exists = User::where(['id' => $insert_data['id']])->exists();

        User::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
        // User::create($insert_data);

        if ($this->createAutomationData) {
            if (!$exists) {
                $user = User::with('sponsor:id,username')
                    ->select('*', DB::raw("
                    CASE
                        WHEN (firstname IS NULL OR firstname = '')
                          AND (lastname IS NULL OR lastname = '')
                        THEN 'NA First'
                        ELSE firstname
                    END AS firstname,
                    CASE
                        WHEN (firstname IS NULL OR firstname = '')
                          AND (lastname IS NULL OR lastname = '')
                        THEN 'NA Last'
                        ELSE lastname
                    END AS lastname
                "))
                    ->where(['id' => $insert_data['id']])->first();

                BrowserAutomationData::create([
                    'user_id' => $insert_data['id'],
                    'type' => 'register',
                    'data' => $user,
                    'action' => '',
                    'datetime' => $insert_data['registered_at'],
                ]);
            }
        }
    }

    private function insert_currency_redemption_rate($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'currency_id' => $temp[1] ?? null,
            'rate' => $temp[2] ?? null,
            'eur_rate' => $temp[3] ?? null,
            'type' => $temp[4] ?? null,
            'status' => $temp[5] ?? null,
            'admin_id' => $temp[6] ?? null,
            'activated_at' => $temp[7] ?? null,
            'created_at' => $temp[8] ?? null,
            'updated_at' => $temp[9] ?? null,
        ];
        CurrencyRedemptionRate::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
    }

    private function insert_wallet($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'user_id' => $temp[1] ?? null,
            'type' => $temp[2] ?? null,
            'balance' => $temp[3] ?? null,
            'created_at' => $temp[4] ?? null,
            'updated_at' => $temp[5] ?? null,
        ];
        Wallet::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
        // Wallet::create($insert_data);
    }

    private function insert_user_extra($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'user_id' => $temp[1] ?? null,
            'type' => $temp[2] ?? null,
            'value' => $temp[3] ?? null,
            'created_at' => $temp[4] ?? null,
            'updated_at' => $temp[5] ?? null,
        ];
        UserExtra::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
    }

    private function insert_user_csr_address($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'user_id' => $temp[1] ?? null,
            'address' => $temp[2] ?? null,
            'created_at' => $temp[3] ?? null,
            'admin_user_id' => $temp[4] ?? null,
        ];
        UserCsrAddress::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
    }

    private function insert_csr_purchase($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'reference' => $temp[1] ?? null,
            'type' => $temp[2] ?? null,
            'wallet_id' => $temp[3] ?? null,
            'flp_amount' => $temp[4] ?? null,
            'address' => $temp[5] ?? null,
            'current_rate' => $temp[6] ?? null,
            'eur_rate' => $temp[7] ?? null,
            'token_amount' => $temp[8] ?? null,
            'gas_price' => $temp[9] ?? null,
            'gas_price_eth' => $temp[10] ?? null,
            'fee_eth' => $temp[11] ?? null,
            'fee_eur' => $temp[12] ?? null,
            'eth_eur_rate' => $temp[13] ?? null,
            'status' => $temp[14] ?? null,
            'token_api_id' => $temp[15] ?? null,
            'queue_id' => $temp[16] ?? null,
            'created_at' => $temp[17] ?? null,
            'updated_at' => $temp[18] ?? null,
            'exported_at' => $temp[19] ?? null,
        ];
        CsrPurchase::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
    }

    private function insert_purchase($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'source' => $temp[1] ?? null,
            'type' => $temp[2] ?? null,
            'user_id' => $temp[3] ?? null,
            'is_promotion' => $temp[4] ?? null,
            'piece' => $temp[5] ?? null,
            'price' => $temp[6] ?? null,
            'ortp' => $temp[7] ?? null,
            'csr' => $temp[8] ?? null,
            'bv' => $temp[9] ?? null,
            'wallet_type' => $temp[10] ?? null,
            'ccw' => $temp[11] ?? null,
            'ecovo' => $temp[12] ?? null,
            'created_at' => $temp[13] ?? null,
            'updated_at' => $temp[14] ?? null,
        ];
        Purchase::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);

        if ($this->createAutomationData) {
            $this->setPurchaseDataForAutomation($insert_data['id']);
        }
    }

    private function setPurchaseDataForAutomation($purchase_id)
    {
        $purchaseAll = Purchase::where('id',$purchase_id)->get();

        if (!empty($purchaseAll)) {
            foreach ($purchaseAll as $purchase){
                $user = User::where('id',$purchase->user_id)->first();
                $userEmail = $user->username ?? '';
                // $userEmail = 'kp@mailinator.com';

                if ($purchase->type == 'coupon') {
                    $purchasePackage = PurchasePackage::where('purchase_id', $purchase_id)->get();

                    $item = [];
                    foreach ($purchasePackage as $package) {
                        $purchaseCoupon = PurchaseCoupon::where('purchase_package_id', $package->id)->first();
                        $type = 'package';
                        $pName = 'PNP';
                        if (strtoupper(substr(($purchaseCoupon->coupon ?? ''), 0, 2)) === 'BL') {
                            $type = 'licence';
                            $pName = 'LIC';
                        }

                        if($purchase->wallet_type == 1){
                            $walletName = 'OCA';
                        } else {
                            $walletName = 'Bonus wallet';
                        }

                        $item[] = [
                            "package" => $pName."-" . number_format($package->price, 0),
                            "type" => $type,
                            "qty" => $package->piece,
                            "wallet" => $walletName,
                        ];
                    }

                    $jayParsedAry = [
                        "email" => $userEmail,
                        "password" => "password@1",
                        "metadata" => [
                            "items" => $item,
                        ]
                    ];

                    BrowserAutomationData::create([
                        'user_id' => $purchase->user_id,
                        'type' => 'purchase',
                        'data' => $jayParsedAry,
                        'action' => '',
                        'datetime' => $purchase->created_at,
                    ]);
                }

                if ($purchase->type == 'redeem') {
                    // ---- START for giftcode redeem
                    $giftcode = PurchaseCoupon::where('redeem_purchase_id', $purchase->id)->first();

                    $jayParsedAry = [
                        "email" => $userEmail,
                        "password" => "password@1",
                        "redeem" => [
                            "code" => $giftcode->coupon ?? '',
                        ]
                    ];

                    BrowserAutomationData::create([
                        'user_id' => $giftcode->redeem_user_id,
                        'type' => 'redeem',
                        'data' => $jayParsedAry,
                        'action' => '',
                        'datetime' => $purchase->created_at,
                    ]);
                }
            }

            return response()->json('Success ' . ($purchase->type ?? ''));
        } else {
            return response()->json('No record found');
        }
    }

    private function insert_user_note($temp){
        $insert_data = [
            'id' => $temp[0] ?? null,
            'iid' => $temp[1] ?? null,
            'user_id' => $temp[2] ?? null,
            'creator_id' => $temp[3] ?? null,
            'remover_id' => $temp[4] ?? null,
            'status' => $temp[5] ?? null,
            'text' => $temp[6] ?? null,
            'created_at' => $temp[7] ?? null,
            'updated_at' => $temp[8] ?? null,
            'removed_at' => $temp[9] ?? null,
        ];
        UserNote::updateOrCreate(['id' => $temp[0] ?? null],$insert_data);
    }
}
