<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('upload-file',[\App\Http\Controllers\Api\ApiController::class,'uploadFile']);
Route::post('start-process',[\App\Http\Controllers\Api\ApiController::class,'startProcess']);
Route::get('get-status',[\App\Http\Controllers\Api\ApiController::class,'getStatus']);

Route::get('bv-information',[\App\Http\Controllers\Api\ApiController::class,'bvInformation']);
Route::get('csrpurchase-information',[\App\Http\Controllers\Api\ApiController::class,'csrpurchaseInformation']);
Route::get('usercsraddress-information',[\App\Http\Controllers\Api\ApiController::class,'usercsraddressInformation']);
Route::get('currencyredemptionrate-information',[\App\Http\Controllers\Api\ApiController::class,'currencyredemptionrateInformation']);
Route::get('purchase-information',[\App\Http\Controllers\Api\ApiController::class,'purchaseInformation']);
Route::get('userextra-information',[\App\Http\Controllers\Api\ApiController::class,'userextraInformation']);
Route::get('userqualificationlog-information',[\App\Http\Controllers\Api\ApiController::class,'userqualificationlogInformation']);
Route::get('userteamsitelicense-information',[\App\Http\Controllers\Api\ApiController::class,'userteamsitelicenseInformation']);
Route::get('user-information',[\App\Http\Controllers\Api\ApiController::class,'userInformation']);
Route::get('wallet-information',[\App\Http\Controllers\Api\ApiController::class,'walletInformation']);
Route::get('walletlog-information',[\App\Http\Controllers\Api\ApiController::class,'walletlogInformation']);
Route::get('user-notes',[\App\Http\Controllers\Api\ApiController::class,'usernotesInformation']);
Route::get('purchase-coupon',[\App\Http\Controllers\Api\ApiController::class,'purchaseCouponInformation']);
Route::get('purchase-package',[\App\Http\Controllers\Api\ApiController::class,'purchasePackageInformation']);

Route::get('get-giftcode-data/{giftCode}',[\App\Http\Controllers\Api\BrowserAutomationApiController::class,'getGiftCodeData']);
